//
//  BIDatabaseConnection.h
//  BISubstrate
//
//  Created by Michael Clark on 30/05/09.
//  Copyright 2009 Marketcircle, Inc. All rights reserved.
//


#import <MCSQLitePersistence/MCSQLiteConnection.h>

@class MCPDatabaseObjectContext;

@interface BIDatabaseConnection : MCSQLiteConnection {
	NSString* __databaseUUID;
}

+ (NSArray*)defaultValues: (id)dbAccess;

- (BOOL)installChangeLog;
- (BOOL)installChangeLogTriggers;
- (BOOL)removeChangeLogTriggers;

- (BOOL)adjustNextPrimaryKeys;
- (void)clearDatabaseUUID;


/*!
 A cover for UPDATE x SET y = b WHERE y = c
 Use NSNull for nulls. Must have all args.
 */
- (BOOL)replaceValueForAttributeNamed:(NSString *)aAttribName 
								 from:(id)originalValue to:(id)newValue 
					   forEntityNamed:(NSString *)aName;

#pragma mark -
#pragma mark Database Default Value Initialization
- (void)populateBillingsDefaultValues; 

/*!
 Convenience for doing complex queries that qualifiers don't support (yet) in Billings
 Be careful that the "from" matches the external name of the entity requested
 */
- (NSArray *)objectsForEntityNamed:(NSString *)ent matchingRawSQL:(NSString *)sql objectContext:(MCPDatabaseObjectContext *)oc;


#ifdef BILLINGS_PRO
/*!
 Returns the number of changes that have to go to the server.
 */
- (NSInteger)pendingChangesCountToBeSyncedToServer;

/*!
 Returns the number of files that to be uploaded to the server - matching the same replicat UUID.
 */
- (NSInteger)pendingUploadsToBeSentToServer;

#endif


@end
